
/*----------------------------------------------------------------------

  file CBeep.c

  This XCMD has the following syntax:

	CBeep		beep once
	CBeep ##	beep n times
	CBeep ?		display usage information
	CBeep !		display version information

  Copyright Apple Computer, Inc.  1989-1991
  All Rights Reserved.
   
----------------------------------------------------------------------*/

#include <types.h>
#include <MiscTool.h>
#include <GSOS.h>
#include <HyperXCMD.h>

/*
	Globals
*/

int	_toolErr;
XCMDPtr	gParamPtr;


/*
	Forwards
*/
pascal void CBeep();



/*  We place the entry point function in its own segment, so the linker can
    extract it and ensure that it's first in the load file.	*/

segment "EntrySeg";

/*
   This is the entry point to the program.  Make sure this procedure
   comes first in the final OMF resource because this is where HyperTalk
   will be jumping in.
   
   For a really simple XCMD you could just put the code all in here, but
   for cleanliness' sake this example calls another routine from here.
   
  
*/
pascal void EntryPoint(paramPtr)
XCMDPtr paramPtr;
{
  CBeep(paramPtr);
}



/*  All other code & data is placed in the "Main" segment	*/

segment "Main";



/*  The actual CBeep function.  Interpret parameters and beep the speaker	*/

pascal void CBeep(paramPtr)
XCMDPtr paramPtr;
{
  short		beepCount;
  short		counter;
  Str255	str;
  
  char	*formStr	= "\pAnswer \"FORM: CBeep {count}\"";
  char	*versionStr	= "\pAnswer \"CBeep XCMD v1.0\" & return & \" 1991 Apple Computer, Inc.\"";
  
  gParamPtr = paramPtr;		/* put in a global for easy access in other funcs	*/
  
  if (paramPtr->paramCount > 0)	{
    ZeroToPas(*(paramPtr->params[0]), &str);
    
    beepCount = 0;
    
    if (str.text[0] == '?')			/* test for special characters	*/
      SendCardMessage(formStr);
    else if (str.text[0] == '!')
      SendCardMessage(versionStr);

    else beepCount = StrToNum(&str);		/* not a special - take as # of beeps */
  }
  else beepCount = 1;	/* no count, assume one */
  
  beepCount = (beepCount <= 15) ? beepCount : 15;	/* limit 15 beeps	*/
  
  for (counter = 0; counter < beepCount; counter++) SysBeep();
}
